#include "GetPoint.js"
#include "GetPointOsnappedOnCurve.js"

function DoArcTangent()
{
	var ui = moi.ui;
	var arcfactory = moi.command.createFactory( 'arctangent' );
	var pointpicker = ui.createPointPicker();
	pointpicker.disableStraightSnap = true;
	pointpicker.enableOnObjectSnap = true;

	if ( !GetPointOsnappedOnCurve( pointpicker ) )
		return;
		
	arcfactory.setInput( 0, false );
	arcfactory.setInput( 1, pointpicker.pt );

	ui.beginUIUpdate();
	ui.hideUI( 'FirstPrompt' );
	ui.showUI( 'SecondPrompt' );
	ui.endUIUpdate();

	if ( !GetPointOsnappedOnCurve( pointpicker ) )
		return;
		
	arcfactory.setInput( 2, pointpicker.pt );
	
	var frame = arcfactory.frame;
	if ( frame == null )
		return;
	pointpicker.restrictToPlane( frame, true );		
	pointpicker.disableBasePt = true;

	ui.beginUIUpdate();
	ui.hideUI( 'SecondPrompt' );
	ui.showUI( 'ThirdPrompt' );
	ui.showUI( 'RadiusOptions' );
	ui.endUIUpdate();

	pointpicker.bindResultPt( arcfactory.getInput(3) );

	ui.commandUI.g_Factory = arcfactory;
	pointpicker.bindFuncPostUpdate( ui.commandUI.OnUpdate );

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'distanceinput' || pointpicker.event == 'circumference' )
		{
		    arcfactory.setInput( 0, ui.commandUI.g_UseRadius );

		    if ( pointpicker.event == 'distanceinput' )
		    {
		        arcfactory.setInput( 4, ui.commandUI.distanceinput.value );
		    }
		    else
		    {
		        var circ = ui.commandUI.circumference.value;
		        arcfactory.setInput( 4, ui.commandUI.g_UseRadius ? circ / (2.0 * Math.PI) : circ / Math.PI );
		    }

		    arcfactory.update();
			break;
		}
		else if ( pointpicker.event == 'finished' )
		{
			break;
		}
	}

	ui.beginUIUpdate();
	ui.hideUI( 'ThirdPrompt' );
	ui.hideUI( 'RadiusOptions' );
	ui.showUI( 'FourthPrompt' );
	ui.endUIUpdate();
	
	pointpicker.clearBindings();
	pointpicker.bindResultPt( arcfactory.getInput( 5 ) );
	
	ui.clearPickedPoints();
	
	if ( !GetPoint( pointpicker ) )
		return;

	arcfactory.commit();
}	

DoArcTangent();
